VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsBNCSHandler"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Index           As Integer
Private Winsock         As Winsock
Private BNLSConnection  As Boolean

'Events
Public Event ShowProfile()
Public Event BNLSVersionCheck(ByVal Index As Integer)
Public Event DisplaySystemKey(ByVal Index As Integer, ByVal Output As String)
Public Event DisplayAvailableChannel(ByVal Index As Integer, ByVal Output As String)
Public Event LadderSearchCallBack(ByRef Rank As Long)

'Output methods
Public Event OutputPacketRecieved(ByVal Index As Integer, ByVal PacketID As String)
Public Event OutputPacketSent(ByVal Index As Integer, ByVal PacketID As String)

Public Function setClassVars(ByRef myIndex As Integer, ByRef myWinsock As Winsock)
    Index = myIndex
    Set Winsock = myWinsock
End Function

Private Sub OptionalExtendedEvents()
'Purpose: To do extended but optional connection things. Such as retrieving system keys, news information.
'         These extended events occur after the ENTER_CHAT sequence occurs.
    
    
    Call sendSID_READUSERDATA(vbNullString)  'Retrieve System Keys
    If (G_Options.ParseNews) Then
        Call sendSID_NEWS_INFO
    End If
End Sub

Public Function preParseData(ByVal Data As String, ByVal bytesTotal As Long)
Dim pktLength       As Long
Dim pktConstant     As Byte
Static strBuffer    As String
    
    strBuffer = strBuffer & Data

    While Len(strBuffer) > 4
        With PktBuffer
            .Reset
            .SetData strBuffer
            .GetByte
            pktConstant = .GetByte
            pktLength = .GetWORD
        End With
        
        If Len(strBuffer) < pktLength Then Exit Function
        
        'If (G_Options.Debug_Mode) Then Debug.Print "Recieved PacketID: 0x" & Hex(pktConstant)
        
        Call handleBNCSPACKETSRAW(pktConstant, Left(strBuffer, pktLength), 0)
        
        strBuffer = Mid(strBuffer, pktLength + 1)
    Wend
End Function

'// Handle the incoming packets:
Private Function handleBNCSPACKETSRAW(ByVal pktConstant As Byte, ByVal Data As String, ByVal ConsecPkts As Integer)
    If (Bots(Index).Connection = 2) Then BNLSConnection = True Else BNLSConnection = False
    
    'Debug.Print DebugOutput(Data)
    
    Select Case pktConstant
        Case SID_AUTH_INFO
            RaiseEvent OutputPacketRecieved(Index, "SID_AUTH_INFO")
            Call handleSID_AUTH_INFO
            
        Case SID_AUTH_CHECK
            RaiseEvent OutputPacketRecieved(Index, "SID_AUTH_CHECK")
            Call handleSID_AUTH_CHECK
        
        Case SID_LOGONRESPONSE2
            RaiseEvent OutputPacketRecieved(Index, "SID_LOGONRESPONSE2")
            Call handleSID_LOGONRESPONSE2
            
        Case SID_CREATEACCOUNT2
            RaiseEvent OutputPacketRecieved(Index, "SID_CREATEACCOUNT2")
            Call handleSID_CREATEACCOUNT2
            
        Case SID_AUTH_ACCOUNTCREATE
            RaiseEvent OutputPacketRecieved(Index, "SID_AUTH_ACCOUNTCREATE")
            Call handleSID_AUTH_ACCOUNTCREATE
            
        Case SID_PING
            RaiseEvent OutputPacketRecieved(Index, "SID_PING")
            Call handleSID_PING
                
        Case SID_AUTH_ACCOUNTLOGON
            RaiseEvent OutputPacketRecieved(Index, "SID_AUTH_ACCOUNTLOGON")
            Call handleSID_AUTH_ACCOUNTLOGON
            
        Case SID_AUTH_ACCOUNTLOGONPROOF
            RaiseEvent OutputPacketRecieved(Index, "SID_ACCOUNTLOGONPROOF")
            Call handleSID_AUTH_ACCOUNTLOGONPROOF
        
        Case SID_SET_EMAIL
            RaiseEvent OutputPacketRecieved(Index, "SID_SET_EMAIL")
            Call handleSID_SET_EMAIL
        
        Case SID_QUERYREALMS2
            RaiseEvent OutputPacketRecieved(Index, "SID_QUERYREALMS2")
            Call handleSID_QUERYREALMS2
        
        Case SID_LOGONREALMEX
            RaiseEvent OutputPacketRecieved(Index, "SID_LOGONREALMEX")
            Call handleSID_LOGONREALMEX
        
        Case SID_ENTERCHAT
            RaiseEvent OutputPacketRecieved(Index, "SID_ENTERCHAT")
            Call handleSID_ENTERCHAT
            
            Call OptionalExtendedEvents
            
        Case SID_NEWS_INFO
            RaiseEvent OutputPacketRecieved(Index, "SID_NEWS_INFO")
            Call handleSID_NEWS_INFO
            
        Case SID_CHATEVENT
            RaiseEvent OutputPacketRecieved(Index, "SID_CHATEVENT")
            Call handleSID_CHATEVENT
            
        Case SID_CHANGEPASSWORD
            RaiseEvent OutputPacketRecieved(Index, "SID_CHANGEPASSWORD")
            Call handleSID_CHANGEPASSWORD
            
        'Friends list packets:
        Case SID_FRIENDLIST
            RaiseEvent OutputPacketRecieved(Index, "SID_FRIENDLIST")
            Call handleSID_FRIENDLIST
            
        Case SID_FRIENDUPDATE
            RaiseEvent OutputPacketRecieved(Index, "SID_FRIENDUPDATE")
            
        Case SID_FRIENDADDED
            RaiseEvent OutputPacketRecieved(Index, "SID_FRIENDADDED")
            
        Case SID_FRIENDREMOVED
            RaiseEvent OutputPacketRecieved(Index, "SID_FRIENDREMOVED")
            
        Case SID_FRIENDMOVED
            RaiseEvent OutputPacketRecieved(Index, "SID_FRIENDMOVED")
            
        'Clan list packets
        Case SID_CLAN_LIST
            RaiseEvent OutputPacketRecieved(Index, "SID_CLAN_LIST")
            Call handleSID_CLAN_LIST
            
        Case SID_GETCHANNELLIST
            RaiseEvent OutputPacketRecieved(Index, "SID_GETCHANNELLIST")
            Call handleSID_GETCHANNELLIST
        
        Case SID_READUSERDATA
            RaiseEvent OutputPacketRecieved(Index, "SID_READUSERDATA")
            handleSID_READUSERDATA
            If (frmProfile.txtAccount <> vbNullString) Then
                RaiseEvent ShowProfile
            End If
            
        Case SID_GETLADDERDATA
            RaiseEvent OutputPacketRecieved(Index, "SID_GETLADDERDATA")
            Call handleSID_GETLADDERDATA
            
        Case SID_FINDLADDERUSER
            RaiseEvent OutputPacketRecieved(Index, "SID_FINDLADDERUSER")
            Call handleSID_FINDLADDERUSER
    End Select
End Function

Private Sub handleSID_READUSERDATA()
    Dim KeysAmount      As Integer
    
    'Reset Type
    With ProfileData
        .pAge = vbNullString
        .pDescription = vbNullString
        .pLastGame.dwHighDateTime = 0
        .pLastGame.dwLowDateTime = 0
        .pLastGameResult = vbNullString
        .pLDisconnects = 0
        .pLHighRank = 0
        .pLHighRating = 0
        .pLLastGame.dwHighDateTime = 0
        .pLLastGame.dwLowDateTime = 0
        .pLLastGameResult = vbNullString
        .pLLoss = 0
        .pLocation = vbNullString
        .pLRank = 0
        .pLRating = 0
        .pLWin = 0
        .pSex = vbNullString
        .pStandardDisc = 0
        .pStandardLosses = 0
        .pStandardWin = 0
    End With
    
    With PktBuffer
        .GetDWORD               '(DWORD)      Number of accounts
        KeysAmount = .GetDWORD  '(DWORD)      Number of keys
        .GetDWORD               '(DWORD)      Request ID
        '(STRING[])   Requested Key Values
        
        Dim prfArray() As String
        prfArray = .GetStringArray(KeysAmount)
        
        Dim i As Integer
        For i = 0 To UBound(prfArray) - 1
            Select Case i
                Case 0 '"profile\sex", "system\account created"
                    If (UBound(prfArray) = 4) Then
                        If (InStr(prfArray(0), Space(1))) Then
                            With RecordData.Created
                                .dwHighDateTime = UnsignedToLong(Val(Split(prfArray(0), Space(1))(0)))
                                .dwLowDateTime = UnsignedToLong(Val(Split(prfArray(0), Space(1))(1)))
                            End With
                            Call ConvertFILETIME(RecordData.Created)
                            RaiseEvent DisplaySystemKey(Index, "Account created: " & vbTab & Space(1) & Get_Date & " at " & Get_Time)
                        End If
                    Else
                        ProfileData.pSex = prfArray(0)
                    End If
                Case 1  '"profile\age", "system\last logon"
                    If (UBound(prfArray) = 4) Then
                        If (InStr(prfArray(1), Space(1))) Then
                            With RecordData.LastLogon
                                .dwHighDateTime = UnsignedToLong(Val(Split(prfArray(1), Space(1))(0)))
                                .dwLowDateTime = UnsignedToLong(Val(Split(prfArray(1), Space(1))(1)))
                            End With
                            Call ConvertFILETIME(RecordData.LastLogon)
                            RaiseEvent DisplaySystemKey(Index, "Last logon: " & vbTab & Space(1) & Get_Date & " at " & Get_Time)
                        End If
                    Else
                        ProfileData.pAge = prfArray(1)
                    End If
                Case 2  '"profile\location", "system\last logoff"
                    If (UBound(prfArray) = 4) Then
                        If (InStr(prfArray(2), Space(1))) Then
                            With RecordData.LastLogoff
                                .dwHighDateTime = UnsignedToLong(Val(Split(prfArray(2), Space(1))(0)))
                                .dwLowDateTime = UnsignedToLong(Val(Split(prfArray(2), Space(1))(1)))
                            End With
                            Call ConvertFILETIME(RecordData.LastLogoff)
                            RaiseEvent DisplaySystemKey(Index, "Last logoff: " & vbTab & Space(1) & Get_Date & " at " & Get_Time)
                        End If
                    Else
                        ProfileData.pLocation = prfArray(2)
                    End If
                Case 3  '"profile\description", "system\time logged"
                    If (UBound(prfArray) = 4) Then
                        If (prfArray(3) <> vbNullString) Then
                            RaiseEvent DisplaySystemKey(Index, "Time logged: " & vbTab & Space(1) & FormatGTC(CLng(prfArray(3)), True))
                            Exit Sub
                        End If
                    Else
                        ProfileData.pDescription = prfArray(3)
                    End If
                Case 4  '"record\GAME\0\wins"
                    ProfileData.pStandardWin = CLng(Val(prfArray(4)))
                Case 5  '"record\GAME\0\losses"
                    ProfileData.pStandardLosses = CLng(Val(prfArray(5)))
                Case 6  '"record\GAME\0\disconnects"
                    ProfileData.pStandardDisc = CLng(Val(prfArray(6)))
                Case 7  '"record\GAME\0\last GAME"
                    If (InStr(prfArray(7), Space(1))) Then
                        With ProfileData.pLastGame
                            .dwHighDateTime = UnsignedToLong(Val(Split(prfArray(7), Space(1))(0)))
                            .dwLowDateTime = UnsignedToLong(Val(Split(prfArray(7), Space(1))(1)))
                        End With
                    End If
                Case 8  '"record\GAME\0\last GAME result"
                    ProfileData.pLastGameResult = prfArray(8)
                Case 9  '"record\GAME\1\wins"
                    ProfileData.pLWin = CLng(Val(prfArray(9)))
                Case 10 '"record\GAME\1\losses"
                    ProfileData.pLLoss = CLng(Val(prfArray(10)))
                Case 11 '"record\GAME\1\disconnects"
                    ProfileData.pLDisconnects = CLng(Val(prfArray(11)))
                Case 12 '"record\GAME\1\last game"
                    If (InStr(prfArray(12), Space(1))) Then
                        With ProfileData.pLLastGame
                            .dwHighDateTime = UnsignedToLong(Val(Split(prfArray(12), Space(1))(0)))
                            .dwLowDateTime = UnsignedToLong(Val(Split(prfArray(12), Space(1))(1)))
                        End With
                    End If
                Case 13 '"record\GAME\1\last game result"
                    ProfileData.pLLastGameResult = prfArray(13)
                Case 14 '"record\GAME\1\rating"
                    ProfileData.pLRating = Val(prfArray(14))
                Case 15 '"record\GAME\1\high rating"
                    ProfileData.pLHighRating = Val(prfArray(15))
                Case 16 '"record\GAME\1\rank"
                    ProfileData.pLRank = Val(prfArray(16))
                Case 17 '"record\GAME\1\high rank"
                    ProfileData.pLHighRank = Val(prfArray(17))
            End Select
        Next i
    End With
End Sub

Private Sub handleSID_AUTH_INFO()
    '// Parse information
    With PktBuffer
        BNETDATA(Index).lngLogonType = .GetDWORD
        Select Case BNETDATA(Index).lngLogonType
            Case 0
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_INFO, "Logon Type: Broken Sha-1 (STAR/SEXP/W2BN/D2DV/D2XP)"
            Case 1
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_INFO, "Logon Type: NLS version 1 (War3Beta)"
            Case 2
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_INFO, "Logon Type: NLS Version 2 (WAR3)"
                BNETDATA(Index).boolUseNLS = True
            Case Else
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, "Logon Type: Unknown"
        End Select
        
        BNETDATA(Index).lngServerToken = .GetDWORD
        PktBuffer.Skip 12
        If (G_Options.Debug_Mode) Then Debug.Print "Position: " & PktBuffer.Position
        BNETDATA(Index).strMPQName = .GetString
        BNETDATA(Index).strValueString = .GetString
        If (BNETDATA(Index).boolUseNLS) Then
            BNETDATA(Index).strServerSignature = .GetFixedString(128)
        End If
    End With
    
    If (BNLSConnection) Then
        RaiseEvent BNLSVersionCheck(Index)
    Else
        sendSID_AUTH_CHECK     '0x51
    End If
End Sub

Private Sub handleSID_AUTH_CHECK()
    Dim Result As Long
    '// Parse information
    Result = PktBuffer.GetDWORD
    Select Case Result
        Case &H0
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_SUCCEED, hBNET & "Version and CDKey check passed"
        Case &H100
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Version check failed (Old game version)"
        Case &H101
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Version check failed (Invalid version)"
        Case &H102
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Version check failed (Must be downgraded)"
        Case &H200
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "CDKey check failed (Invalid cdkey)"
        Case &H201
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "CDKey check failed (In use: " & PktBuffer.GetString & ")"
        Case &H202
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "CDKey check failed (Banned)"
        Case &H203
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "CDKey check failed (Wrong product)"
        Case &H210
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Expansion cdkey check failed (Invalid cdkey)"
        Case &H211
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Expansion cdkey check failed (In use: " & PktBuffer.GetString & ")"
        Case &H212
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Expansion cdkey check failed (Banned)"
        Case &H213
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Expansion cdkey check failed (Wrong product)"
    End Select
    
    If (Bots(Index).Client = PRODUCT_WAR3 Or Bots(Index).Client = PRODUCT_W3XP) Then
        If (Bots(Index).Change_Pass) Then
            sendSID_CHANGEPASSWORD
        Else
            sendSID_AUTH_ACCOUNTLOGON
        End If
    Else
        If (Result <> &H0) Then
            'Disconnect bot
        Else
            If (Bots(Index).Change_Pass) Then
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_PROCESS, hBNET & "Attempting to change password"
                sendSID_CHANGEPASSWORD
            Else
                sendSID_LOGONRESPONSE2  '0x3A
                sendSID_UDPPINGRESPONSE '0x14
            End If
        End If
    End If
End Sub
Private Sub handleSID_LOGONRESPONSE2()
    Dim Result As Long
    'sendSID_ENTERCHAT if successful, otherwise create/display message.
    Result = PktBuffer.GetDWORD
    Select Case Result
        Case &H0
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_SUCCEED, hBNET & "Login successful"
        Case &H1
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Login failed (Account doesn't exist)"
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_PROCESS, hBNET & "Attempting to create account"
            sendSID_CREATEACCOUNT2
            Exit Sub
        Case &H2
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Login failed (Invalid password)"
    End Select
    
    If (Result <> &H0) Then
        'Disconnect bot
    Else
        If (G_Options.Show_Available_Channels) Then
            sendSID_GETCHANNELLIST
        End If
        Call sendSID_ENTERCHAT
        Call sendSID_JOINCHANNEL(Bots(Index).Home)
    End If
End Sub

Private Sub handleSID_AUTH_ACCOUNTCREATE()
    Dim Result As Long
    Result = PktBuffer.GetDWORD
    Select Case Result
        Case &H0
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_SUCCEED, hBNET & "Account creation successful"
        Case &H7
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Account creation failed (Account too short)"
        Case &H8
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Account creation failed (Account contains illegal characters)"
        Case &H9
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Account creation failed (Account contains bad word)"
        Case &HA
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Account creation failed (Account does not contain enough alphanumeric characters)"
        Case &HB
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Account creation failed (Account contains adjacent punctuation characters)"
        Case &HC
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Account creation failed (Account contains too many punctuation characters)"
        Case Else
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Account creation failed"
    End Select
    
    If (Result <> &H0) Then
        'Disconnect bot
    Else
        Call sendSID_AUTH_ACCOUNTLOGON
    End If
End Sub

Private Sub handleSID_CREATEACCOUNT2()
    Dim Result As Long
    Result = PktBuffer.GetDWORD
    Select Case Result
        Case &H0
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_SUCCEED, hBNET & "Account creation successful"
        Case &H2
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Account creation failed (Contained a invalid characters)"
        Case &H3
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Account creation failed (Contained a bad word)"
        Case &H4
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Account creation failed (Account already exists)"
        Case &H6
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Account creation failed (Account too short)"
    End Select
    
    If (Result <> &H0) Then
        'Disconnect bot
    Else
        Call sendSID_LOGONRESPONSE2
    End If
End Sub

Private Sub handleSID_PING()
    'determine spoofing levels and sendSID_PING accordingly.
    
    'Don't respond for spoofing to -1ms
    If (Bots(Index).Spoof <> -1 And Bots(Index).Spoof <> 0) Then
        sendSID_PING
    End If
End Sub

Private Sub handleSID_AUTH_ACCOUNTLOGON()
    Dim Result As Long
    'If successful sendSID_ACCOUNTLOGONPROOF
    With PktBuffer
        Result = .GetDWORD
        Select Case Result
            Case &H0
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_SUCCEED, hBNET & "Login accepted, requires proof"
            Case &H1
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Login failed (Account doesn't exist)"
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_PROCESS, hBNET & "Attempting to create account"
                sendSID_AUTH_ACCOUNTCREATE
                Exit Sub
            Case &H5
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Login failed (Account requires upgrade)"
            Case Else
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Login failed (Unknown)"
        End Select
    End With
        
    If (Result <> &H0) Then
    Else
        sendSID_AUTH_ACCOUNTLOGONPROOF
    End If
End Sub

Private Sub handleSID_AUTH_ACCOUNTLOGONPROOF()
    Dim M2 As String * 20
    Dim Status As Long
    'If successful sendSID_ENTERCHAT
    With PktBuffer
        Status = .GetDWORD
        Select Case Status
            Case &H0, &HE
                M2 = .GetFixedString(20)
                If (nls_check_M2(BNETDATA(Index).lngNLS, M2, vbNullString, vbNullString) = 0) Then
                    AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Server password proof failed"
                    Exit Sub
                End If
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_SUCCEED, hBNET & "Logon successful"
                nls_free (BNETDATA(Index).lngNLS)
                BNETDATA(Index).lngNLS = 0
                
                If (Status = &HE) Then  'Set email
                    Call sendSID_SET_EMAIL
                End If
                
                If (G_Options.Show_Available_Channels) Then
                    sendSID_GETCHANNELLIST
                End If
                Call sendSID_ENTERCHAT
                Call sendSID_JOINCHANNEL(Bots(Index).Home)
            Case &H2
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Login failed (Incorrect password)"
            Case &HF
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Login failed (" & .GetString & ")"
        End Select
    End With
End Sub

Private Sub handleSID_SET_EMAIL()
    AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Account is not registered to an email address"
    If (Bots(Index).Email <> vbNullString) Then
        AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_PROCESS, hBNET & "Attempting to bind email address to the account (" & Bots(Index).Email & ")"
        sendSID_SET_EMAIL
    End If
End Sub

Private Sub handleSID_QUERYREALMS2()
    With PktBuffer
        .GetDWORD
        .GetDWORD
        .GetDWORD
        Call sendSID_LOGONREALMEX(.GetString)
    End With
End Sub

Private Sub handleSID_CHATEVENT()
    Dim eventID     As Long
    Dim userFlags   As Long
    Dim userPing    As Long
    Dim Username    As String
    Dim userMessage As String
    With PktBuffer
        eventID = .GetDWORD         '(DWORD)      Event ID
        userFlags = .GetDWORD       '(DWORD)      User's Flags
        userPing = .GetDWORD        '(DWORD)      Ping
        .GetDWORD                   '(DWORD)      IP Address (Defunct)
        .GetDWORD                   '(DWORD)      Account number (Defunct)
        .GetDWORD                   '(DWORD)      Registration Authority (Defunct)
        Username = .GetString       '(STRING)     Username
        userMessage = .GetString    '(STRING)     Text
    End With
    Call EVENTHandler(Index, eventID, Username, Mid$(userMessage, 1, 4), userFlags, userPing, userMessage)
End Sub

Private Sub handleSID_ENTERCHAT()
    'Set variables accordingly as well as other things.
    With PktBuffer
        Bots(Index).RealUsername = .GetString
        Bots(Index).Statstring = .GetString
    End With
    If (Bots(Index).UseRealm) Then
        If (Bots(Index).Client = PRODUCT_D2DV Or Bots(Index).Client = PRODUCT_D2XP) Then
            sendSID_QUERYREALMS2
        End If
    End If
End Sub

Private Sub handleSID_GETCHANNELLIST()
    Dim ChanHandler As New clsHandlerChannel
    Dim spltChannels() As String
    Dim i As Integer
    
    spltChannels() = Split(PktBuffer.GetData, vbNullChar)
    
    RaiseEvent DisplayAvailableChannel(Index, "Available channels for " & ChanHandler.MakeLongClientName(Bots(Index).Product))
    For i = 1 To UBound(spltChannels) - 1
        If (spltChannels(i) <> vbNullString) Then
            'Simple fix
            If Len(spltChannels(i)) < 5 Then Exit Sub
            RaiseEvent DisplayAvailableChannel(Index, Space(3) & "- " & Trim$(spltChannels(i)))
        End If
    Next i
    Erase spltChannels()
End Sub

Private Sub handleSID_LOGONREALMEX()
    With PktBuffer
        .GetDWORD
        Select Case .GetDWORD
            Case &H80000001
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Realm is unavailable"
                Exit Sub
            Case &H80000002
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, hBNET & "Realm logon failed"
                Exit Sub
        End Select
        Dim IP As String
        Dim Port As Long
        .Skip -8
        BNETDATA(Index).strMCPChunk1 = .GetFixedString(16)
        IP = GetInetStrFromPtr(.GetDWORD)
        Port = .GetDWORD
        BNETDATA(Index).strMCPChunk2 = .GetFixedString(48)
        Bots(Index).RealUsername = .GetString
        
        AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_PROCESS, hMCP & "Attempting to connect to realm"
        
        With frmMain.sckREALM(Index)
            .Close
            .RemoteHost = IP
            .RemotePort = 6112
            .Connect
        End With
        
        'Debug.Print "MCP Chunk 1: " & BNETDATA(Index).strMCPChunk1
        'Debug.Print "IP: " & IP
        'Debug.Print "Port: " & Port
        'Debug.Print "MCP Chunk 2: " & BNETDATA(Index).strMCPChunk2
    End With
End Sub

Private Sub handleSID_CLAN_LIST()
    'For each member:
                                    '(DWORD)       Cookie
    Dim clClanAmount    As Integer  '(BYTE)        Number of Members
    Dim clUsername      As String   '(STRING)      Username
    Dim clRank          As Byte     '(BYTE)        Rank
    Dim clOnlineStatus  As Byte     '(BYTE)        Online Status
                                    '(BYTE)        Unknown (0)
    Call ProfileHandler(Index).UserListing.Reset(CLAN_USER)
    
    
    With PktBuffer
        .GetDWORD                   'Cookie
        clClanAmount = .GetByte
        
        Dim i As Integer
        
        For i = 0 To clClanAmount
            clUsername = Trim$(.GetString)
            clRank = .GetByte
            clOnlineStatus = .GetByte
            .GetByte                'Increment data for Unknown (0)
            
            If (clUsername <> vbNullString) Then
                Call ProfileHandler(Index).UserListing.handleClanList(Index, clUsername, clRank, clOnlineStatus)
            End If
            
            clUsername = vbNullString
            clRank = vbNull
            clOnlineStatus = vbNull
        Next i
    End With
End Sub

Private Sub handleSID_FRIENDLIST()
    'Remarks: This packet contains the current user's Friends List. If the friend is offline, their ProductID is 0. Location is only supplied when it is relevant - for example, if Status is set to offline (0x00), the location string will be empty.
    
    Dim flFriendCount   As Integer  '(BYTE)       Number of Entries
    Dim flUsername      As String   '(STRING)     Account
    Dim flStatus        As Long     '(BYTE)       Status
    Dim flLocation      As Long     '(BYTE)       Location
    Dim flProdID        As String   '(DWORD)      ProductID
    Dim flChannel       As String   '(STRING)     Channel
    Dim flStrLocation   As String
    
    Call ProfileHandler(Index).UserListing.Reset(FRIEND_USER)  'Reset friend listing
    
    With PktBuffer
        flFriendCount = .GetByte 'Get amount of friends
        Dim i As Integer
        For i = 1 To flFriendCount
            flUsername = .GetString
            flStatus = .GetByte
            flLocation = .GetByte
            
            .GetDWORD
            
            flChannel = .GetString
            
            flProdID = Mid$(.RawData, .Position - Len(flChannel) - 5, 4)
            
            'Possible bitwise values for Status:
            '0x01: Mutual
            '0x02: DND
            '0x04: Away
            
            'Handle the data in userlisting class:
            Call ProfileHandler(Index).UserListing.handleFriendsList(Index, flUsername, flStatus, flLocation, flProdID, flChannel)
                       
            'Reset for next loop
            flUsername = vbNullString
            flStatus = vbNull
            flLocation = vbNull
            flProdID = vbNull
            flChannel = vbNullString
            flStrLocation = vbNullString
        Next i
    End With
End Sub

Private Function handleSID_GETLADDERDATA()
Dim lRank           As Long
Dim lUsername       As String
Dim lRating         As Long
Dim lWins           As Long
Dim lLosses         As Long
Dim lDisconnects    As Long
Dim lLastGame       As String
Dim lCount          As Long
Dim lLadderLeague   As Long
Dim lSortMethod     As Long
Dim lStartingRank   As Long
Dim lLadderType     As Long
Dim i As Integer

'Debug.Print DebugOutput(PktBuffer.RawData)

    With PktBuffer
        lLadderType = .GetDWORD
        lLadderLeague = .GetDWORD
        lSortMethod = .GetDWORD
        lStartingRank = .GetDWORD
        lCount = .GetDWORD
        
        'Call frmLadder.setLadderInfo(lSortMethod, lCount)
        frmLadder.lvLadder.ListItems.Clear
        frmLadder.txtPosition = lStartingRank + 1 & " - " & lStartingRank + 10
        
        For i = 1 To lCount
            If lLadderType = 0 Then
                lWins = .GetDWORD
                lLosses = .GetDWORD
                lDisconnects = .GetDWORD
                lRating = .GetDWORD
                lRank = .GetDWORD
                .Skip 44
                lLastGame = .GetFixedString(8)
                .GetFixedString (8)
            Else
                .Skip 20
                lWins = .GetDWORD
                lLosses = .GetDWORD
                lDisconnects = .GetDWORD
                lRating = .GetDWORD
                .GetDWORD
                lRank = .GetDWORD
                .GetDWORD
                .GetDWORD
                .GetDWORD
                .GetDWORD
                .GetDWORD
                'Debug.Print DebugOutput(.RawData)
                .GetFixedString (8)
                lLastGame = .GetFixedString(8)
            End If
            
            lUsername = .GetString
            
            Call frmLadder.addUserLadder(lUsername, lWins, lLosses, lDisconnects, lRating, lRank + 1, lLastGame)
        Next i
    End With
End Function

Private Function handleSID_FINDLADDERUSER()
Dim lRank As Long

    With PktBuffer
        lRank = .GetDWORD
    End With
    
    RaiseEvent LadderSearchCallBack(lRank)
End Function

Private Function handleSID_NEWS_INFO()
Dim iEntries As Integer
Dim i As Integer

    With PktBuffer
        iEntries = .GetByte
        .Skip 12
        
        For i = 1 To iEntries
            .GetDWORD
            Dim NewsData    As String
            NewsData = .GetString
            
            Dim SpltNews()  As String
            SpltNews() = Split(NewsData, Chr$(&HA))
                        
            Dim j As Integer
            
            For j = 0 To UBound(SpltNews)
                If (SpltNews(j) <> vbNullString) Then
                    AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_INFO, SpltNews(j)
                End If
            Next j
        Next i
    End With
End Function

Private Function handleSID_CHANGEPASSWORD()
    With PktBuffer
        If (.GetBoolean) Then
            Bots(Index).Change_Pass = False
            Bots(Index).Password = Bots(Index).New_Password
            Bots(Index).New_Password = vbNullString
            
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_SUCCEED, hBNET & "Password changed successfully"
            sendSID_LOGONRESPONSE2
        Else
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_INFO, hBNET & "Password change failed"
        End If
    End With
End Function

'// Handle the outgoing packets:
Private Function sendSID_ENTERCHAT()
    With PktBuffer
        .Reset
        .InsertNTString Mid(Bots(Index).Username, 1, 15) 'In case username is too long
        .InsertNTString vbNullString
        
        .Send Winsock, SID_ENTERCHAT, pBNET
    End With
    RaiseEvent OutputPacketSent(Index, "SID_ENTERCHAT")
End Function

Public Function sendSID_JOINCHANNEL(ByRef ChannelName As String)
    If (ChannelName <> vbNullString) Then
        With PktBuffer
            .Reset
            .InsertDWORD &H2
            .InsertNTString ChannelName
            
            .Send Winsock, SID_JOINCHANNEL, pBNET
        End With
        RaiseEvent OutputPacketSent(Index, "SID_JOINCHANNEL")
    End If
End Function

Private Function sendSID_PING()
    With PktBuffer
        .Reset
        .InsertDWORD &H0
        
        .Send Winsock, SID_PING, pBNET
    End With
    RaiseEvent OutputPacketSent(Index, "SID_PING")
End Function

Private Function sendSID_CHANGEPASSWORD()
    With PktBuffer
        .Reset
        .InsertDWORD BNETDATA(Index).lngClientToken
        .InsertDWORD BNETDATA(Index).lngServerToken
        .InsertNonNTString doubleHashPassword(Bots(Index).Password, BNETDATA(Index).lngClientToken, BNETDATA(Index).lngServerToken)
        .InsertNonNTString hashPassword(Bots(Index).New_Password)
        .InsertNTString Bots(Index).Username
        
        .Send Winsock, SID_CHANGEPASSWORD, pBNET
    End With
    RaiseEvent OutputPacketSent(Index, "SID_CHANGEPASSWORD")
End Function

Private Function sendSID_CREATEACCOUNT2()
    With BNETDATA(Index)
        .strAccountHash = hashPassword(LCase$(Bots(Index).Password))
    End With
    
    With PktBuffer
        .Reset
        .InsertNonNTString BNETDATA(Index).strAccountHash
        .InsertNTString Bots(Index).Username
        
        .Send Winsock, SID_CREATEACCOUNT2, pBNET
    End With
    RaiseEvent OutputPacketSent(Index, "SID_CREATEACCOUNT2")
End Function

Private Function sendSID_NEWS_INFO()
    With PktBuffer
        .InsertDWORD &H0
        .Send Winsock, SID_NEWS_INFO, pBNET
    End With
    
    RaiseEvent OutputPacketSent(Index, "SID_NEWS_INFO")
End Function

Public Function sendSID_AUTH_INFO()
    
    If (G_Options.Debug_Mode) Then
        Debug.Print "SID_AUTH_INFO -> Profile: " & Bots(Index).Profile
        Debug.Print "SID_AUTH_INFO -> Version Byte: 0x" & Hex(Bots(Index).VerByte)
        Debug.Print "SID_AUTH_INFO -> Product: " & Bots(Index).Product
    End If
    
    With PktBuffer
        .Reset
        .InsertDWORD &H0
        .InsertNonNTString StrReverse("IX86") & Bots(Index).Product
        .InsertDWORD Bots(Index).VerByte
        .InsertDWORD &H0
        .InsertDWORD &H0
        .InsertDWORD &H0
        .InsertDWORD &H0
        .InsertDWORD &H409
        .InsertNTString "USA"
        .InsertNTString "United States"
        
        .Send Winsock, SID_AUTH_INFO, pBNET
        
        If (Bots(Index).Spoof <> -1) Then
            sendSID_PING
        End If
        
        RaiseEvent OutputPacketSent(Index, "SID_AUTH_INFO")
    End With
End Function

Public Function sendSID_AUTH_CHECK()
    Dim decoder As Long
    Dim BNLSConnection  As Boolean
        
    If (Bots(Index).Connection = 2) Then BNLSConnection = True
    
    If (Not BNLSConnection) Then
        With BNETDATA(Index)
            .lngClientToken = GetTickCount()
            If (G_Options.Debug_Mode) Then Debug.Print "MPQName: " & BNETDATA(Index).strMPQName
            .lngMPQNumber = extractMPQNumber(.strMPQName)
            If (G_Options.Debug_Mode) Then Debug.Print "MPQNumber: " & BNETDATA(Index).lngMPQNumber
            
            If (.lngMPQNumber < 0) Then
                Call closeBot(Index)
                If (G_Options.Debug_Mode) Then
                    Debug.Print "Error: Invalid MPQ Number."
                End If
                Exit Function
            End If
                    
            If (G_Options.Debug_Mode) Then Debug.Print "ValueString: " & BNETDATA(Index).strValueString
    
            If (G_Options.Debug_Mode) Then
                Debug.Print "HashDir(0): " & HashDir(0)
                Debug.Print "HashDir(1): " & HashDir(1)
                Debug.Print "HashDir(2): " & HashDir(2)
            End If
            
            If checkRevision(.strValueString, HashDir(0), HashDir(1), HashDir(2), .lngMPQNumber, .lngCheckSum) = False Then
                Call closeBot(Index)
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, "Check Revision failed! Please check your hash files."
                Exit Function
            Else
                AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_SUCCEED, "Check Revision passed!"
            End If
                
            If (G_Options.Debug_Mode) Then Debug.Print "CheckSum: " & BNETDATA(Index).lngCheckSum
                
            .strEXEInfo = String$(256, vbNullChar)
            .lngExeVersion = getExeInfo(HashDir(0), .strEXEInfo)
            If (G_Options.Debug_Mode) Then Debug.Print "ExeVersion: " & BNETDATA(Index).lngExeVersion
                
            If (.lngExeVersion = 0) Then
                Call closeBot(Index)
                If (G_Options.Debug_Mode) Then
                    Debug.Print "Error: Executable version -> " & .lngExeVersion
                End If
                Exit Function
            End If
        End With
    End If
        
    decoder = kd_create(Bots(Index).P_CDKey, Len(Bots(Index).P_CDKey))
        
    If (decoder = -1) Then
        Call closeBot(Index)
        Debug.Print "Error: Could not decode cdkey: " & Bots(Index).P_CDKey
    End If
        
    With BNETDATA(Index)
        .lngHashLength = kd_calculateHash(decoder, .lngClientToken, .lngServerToken)
        .strHash = String$(.lngHashLength, vbNullChar)
        Call kd_getHash(decoder, .strHash)
    End With

    With PktBuffer
        .Reset
        If (G_Options.Debug_Mode) Then Debug.Print "Client Token: " & BNETDATA(Index).lngClientToken
        .InsertDWORD BNETDATA(Index).lngClientToken
        .InsertDWORD BNETDATA(Index).lngExeVersion
        .InsertDWORD BNETDATA(Index).lngCheckSum
        If (Bots(Index).Client = PRODUCT_D2XP Or Bots(Index).Client = PRODUCT_W3XP) Then
            .InsertDWORD &H2
        Else
            .InsertDWORD &H1
        End If
        .InsertDWORD &H0
        .InsertDWORD Len(Bots(Index).P_CDKey)
        .InsertDWORD kd_product(decoder)
        .InsertDWORD kd_val1(decoder)
        .InsertDWORD &H0
        If (G_Options.Debug_Mode) Then Debug.Print "strHash: " & BNETDATA(Index).strHash
        .InsertNonNTString BNETDATA(Index).strHash
        If (Bots(Index).Client = PRODUCT_D2XP Or Bots(Index).Client = PRODUCT_W3XP) Then
            Call kd_free(decoder)
            decoder = kd_create(Bots(Index).E_CDKey, Len(Bots(Index).E_CDKey))
            If (decoder = -1) Then
                Call closeBot(Index)
                Debug.Print "Error: Could not decode cdkey: " & Bots(Index).E_CDKey
            End If
            With BNETDATA(Index)
                .lngHashLength = kd_calculateHash(decoder, .lngClientToken, .lngServerToken)
                .strHash = String$(.lngHashLength, vbNullChar)
                Call kd_getHash(decoder, .strHash)
            End With
            .InsertDWORD Len(Bots(Index).P_CDKey)
            .InsertDWORD kd_product(decoder)
            .InsertDWORD kd_val1(decoder)
            .InsertDWORD &H0
            .InsertNonNTString BNETDATA(Index).strHash
        End If
        If (G_Options.Debug_Mode) Then Debug.Print "strExeInfo: " & BNETDATA(Index).strEXEInfo
        .InsertNTString BNETDATA(Index).strEXEInfo
        If (G_Options.Debug_Mode) Then Debug.Print "Username: " & Bots(Index).Username
        .InsertNTString Bots(Index).Username
            
        .Send Winsock, SID_AUTH_CHECK, pBNET
    End With
        
    Call kd_free(decoder)

    RaiseEvent OutputPacketSent(Index, "SID_AUTH_CHECK")
End Function

Private Function sendSID_AUTH_ACCOUNTCREATE()
    Dim Buffer As String, BufLen As Long
    
    BufLen = 65 + Len(Bots(Index).Username)
    Buffer = String$(BufLen, vbNullChar)
    
    If (nls_account_create(BNETDATA(Index).lngNLS, Buffer, BufLen) = 0) Then
        AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, "Failed to create account"
        Exit Function
    End If
    
    With PktBuffer
        .Reset
        .InsertNonNTString Buffer
        
        .Send Winsock, SID_AUTH_ACCOUNTCREATE, pBNET
    End With
    
    RaiseEvent OutputPacketSent(Index, "SID_AUTH_ACCOUNTCREATE")
End Function

Private Function sendSID_AUTH_ACCOUNTLOGON()
    Dim ClientKey As String * 32

    If (BNETDATA(Index).lngNLS = 0) Then
        BNETDATA(Index).lngNLS = nls_init(Bots(Index).Username, Bots(Index).Password)
        If (BNETDATA(Index).lngNLS = 0) Then
            AddC Index, frmMain.rtbChat, True, COLORS.ID_COLOR_FAILED, "Failed to initialize NLS"
            closeBot (Index)
            Exit Function
        End If
        
    End If
    
    Call nls_get_A(BNETDATA(Index).lngNLS, ClientKey)
    
    If (G_Options.Debug_Mode) Then Debug.Print "NLS: " & BNETDATA(Index).lngNLS
    If (G_Options.Debug_Mode) Then Debug.Print "ClientKey (A): " & ClientKey
    
    With PktBuffer
        .Reset
        .InsertNonNTString ClientKey
        .InsertNTString Bots(Index).Username
        
        .Send Winsock, SID_AUTH_ACCOUNTLOGON, pBNET
    End With
    
    RaiseEvent OutputPacketSent(Index, "SID_AUTH_ACCOUNTLOGON")
End Function

Private Function sendSID_AUTH_ACCOUNTLOGONPROOF()
    Dim M1 As String * 20
    
    BNETDATA(Index).strSalt = PktBuffer.GetFixedString(32)
    BNETDATA(Index).strServerKey = PktBuffer.GetFixedString(32)
    
    Call nls_get_M1(BNETDATA(Index).lngNLS, M1, BNETDATA(Index).strServerKey, BNETDATA(Index).strSalt)
    
    With PktBuffer
        .Reset
        .InsertNonNTString M1
        
        .Send Winsock, SID_AUTH_ACCOUNTLOGONPROOF, pBNET
    End With
    RaiseEvent OutputPacketSent(Index, "SID_ENTERCHAT")
End Function

Private Function sendSID_AUTH_ACCOUNTCHANGE()
    With PktBuffer
        
    End With
    RaiseEvent OutputPacketSent(Index, "SID_AUTH_ACCOUNTLOGONPROOF")
End Function

Private Function sendSID_AUTH_AUTOCHANGEPROOF()
    With PktBuffer
    
    End With
    RaiseEvent OutputPacketSent(Index, "SID_AUTH_AUTOCHANGEPROOF")
End Function

Private Function sendSID_SET_EMAIL()
    If (InStr(Bots(Index).Email, "@") And Len(Bots(Index).Email) > 5) Then 'Shortest email address: a@a.us
        With PktBuffer
            .InsertNTString Bots(Index).Email
            
            .Send Winsock, SID_SET_EMAIL, pBNET
        End With
        RaiseEvent OutputPacketSent(Index, "SID_SET_EMAIL")
    End If
End Function

Public Function sendSID_FRIENDLIST()
    With PktBuffer
        .Reset
        .Send Winsock, SID_FRIENDLIST, pBNET
    End With
    RaiseEvent OutputPacketSent(Index, "SID_FRIENDLIST")
End Function

Public Function sendSID_CLANLIST()
    With PktBuffer
        .Reset
        .InsertDWORD GetTickCount()
        .Send Winsock, SID_CLAN_LIST, pBNET
    End With
    RaiseEvent OutputPacketSent(Index, "SID_CLANLIST")
End Function

Private Function sendSID_LOGONRESPONSE2()
    With BNETDATA(Index)
        .strAccountHash = doubleHashPassword(Bots(Index).Password, .lngClientToken, .lngServerToken)
    End With
    
    With PktBuffer
        .Reset
        .InsertDWORD BNETDATA(Index).lngClientToken
        .InsertDWORD BNETDATA(Index).lngServerToken
        .InsertNonNTString BNETDATA(Index).strAccountHash
        .InsertNTString Bots(Index).Username
        
        .Send Winsock, SID_LOGONRESPONSE2, pBNET
    End With
    
    RaiseEvent OutputPacketSent(Index, "SID_LOGONRESPONSE2")
End Function

Private Function sendSID_QUERYREALMS2()
    With PktBuffer
        .Reset
                
        .Send Winsock, SID_QUERYREALMS2, pBNET
    End With
    RaiseEvent OutputPacketSent(Index, "SID_QUERYREALMS2")
End Function

Private Function sendSID_LOGONREALMEX(ByVal RealmName As String)
Dim RealmPassHash As String

    With BNETDATA(Index)
        RealmPassHash = doubleHashPassword("password", BNETDATA(Index).lngClientToken, BNETDATA(Index).lngServerToken)
    End With

    With PktBuffer
        .Reset
        .InsertDWORD BNETDATA(Index).lngClientToken
        .InsertNonNTString RealmPassHash
        .InsertNTString RealmName
        
        .Send Winsock, SID_LOGONREALMEX, pBNET
    End With
    RaiseEvent OutputPacketSent(Index, "SID_LOGONREALMEX")
End Function


Private Function sendSID_UDPPINGRESPONSE()
    If (Bots(Index).Bot_Plug = False) Then
        With PktBuffer
            .Reset
            .InsertDWORD &H626E6574 'tenb
            
            .Send Winsock, SID_UDPPINGRESPONSE, pBNET
        End With
    End If
End Function

Private Function sendSID_GETCHANNELLIST()
    With PktBuffer
        .Reset
        .InsertNonNTString Bots(Index).Product
        
        .Send Winsock, SID_GETCHANNELLIST, pBNET
    End With
    
    RaiseEvent OutputPacketSent(Index, "SID_GETCHANNELLIST")
End Function

Public Function sendSID_GETLADDERDATA(ByVal SortMethod As LadderSortMethod, ByVal StartingRank As Long, LadderLeague As Long, Client As String)
    With PktBuffer
         
        'Get DWORD value of the ProductID
        .Reset                      'Reset buffer
        .SetData Client
         
        Dim ProductID As Long
        ProductID = .GetDWORD
        
        .Reset                      'Reset buffer
 
        .InsertDWORD ProductID          '(DWORD)      Product ID
        .InsertDWORD &H1                '(DWORD)      League
        .InsertDWORD SortMethod         '(DWORD)      Sort method
        .InsertDWORD StartingRank       '(DWORD)      Starting rank
        .InsertDWORD 10                 '(DWORD)      Number of ranks to list
        .Send Winsock, SID_GETLADDERDATA, pBNET
    End With
    
    RaiseEvent OutputPacketSent(Index, "SID_GETLADDERDATA")
End Function

Public Function sendSID_FINDLADDERUSER(ByVal Username As String)
    With PktBuffer
        .Reset
        .InsertDWORD 1
        .InsertDWORD 0
        .InsertNTString Username
        
        .Send Winsock, SID_FINDLADDERUSER, pBNET
    End With
    
    RaiseEvent OutputPacketSent(Index, "SID_FINDLADDERUSER")
End Function

Public Function sendSID_READUSERDATA(ByVal Username As String)
    
    Dim ReqProduct As String
    ReqProduct = UCase$(StrReverse$(Bots(Index).Product))
    
    With PktBuffer
        .Reset
        .InsertDWORD 1                      '(DWORD)      Number of Accounts
        If (Username <> vbNullString) Then
            .InsertDWORD 18                 '(DWORD)      Number of Keys [profile]
        Else
            .InsertDWORD 4                  '(DWORD)      Number of Keys [recorddata]
        End If
        .InsertDWORD GetTickCount()         '(DWORD)      Request ID
        
        If (Username <> vbNullString) Then
            .InsertNTString Username            '(STRING[])   Requested Accounts
        Else
            .InsertNTString Bots(Index).RealUsername
        End If
        
        If (Username <> vbNullString) Then
            '(STRING[])   Requested Keys (18 total)
            .InsertNTString "profile\sex"
            .InsertNTString "profile\age"
            .InsertNTString "profile\location"
            .InsertNTString "profile\description"
            .InsertNTString "record\" & ReqProduct & "\0\wins"
            .InsertNTString "record\" & ReqProduct & "\0\losses"
            .InsertNTString "record\" & ReqProduct & "\0\disconnects"
            .InsertNTString "record\" & ReqProduct & "\0\last GAME"
            .InsertNTString "record\" & ReqProduct & "\0\last GAME result"
            .InsertNTString "record\" & ReqProduct & "\1\wins"
            .InsertNTString "record\" & ReqProduct & "\1\losses"
            .InsertNTString "record\" & ReqProduct & "\1\disconnects"
            .InsertNTString "record\" & ReqProduct & "\1\last GAME"
            .InsertNTString "record\" & ReqProduct & "\1\last GAME result"
            .InsertNTString "record\" & ReqProduct & "\1\rating"
            .InsertNTString "record\" & ReqProduct & "\1\high rating"
            .InsertNTString "record\" & ReqProduct & "\1\rank"
            .InsertNTString "record\" & ReqProduct & "\1\high rank"
        Else
            '(STRING[])   Requested Keys (4 total)
            .InsertNTString "system\account created"
            .InsertNTString "system\last logon"
            .InsertNTString "system\last logoff"
            .InsertNTString "system\time logged"
        End If
        
        .Send Winsock, SID_READUSERDATA, pBNET
    End With
    RaiseEvent OutputPacketSent(Index, "SID_READUSERDATA")
End Function

Public Function sendSID_WRITEUSERDATA(ByVal Sex As String, ByVal Age As String, ByVal Location As String, ByVal Description As String)
    With PktBuffer
        .Reset
        .InsertDWORD 1                          '(DWORD)      Number of accounts
        .InsertDWORD 4                          '(DWORD)      Number of keys
        .InsertNTString Bots(Index).Username    '(STRING[])   Accounts to update
        '(STRING[])   Keys to update
        .InsertNTString "profile\sex"
        .InsertNTString "profile\age"
        .InsertNTString "profile\location"
        .InsertNTString "profile\description"
        '(STRING[])   New values
        .InsertNTString Sex
        .InsertNTString Age
        .InsertNTString Location
        .InsertNTString Description
        
        .Send Winsock, SID_WRITEUSERDATA, pBNET
    End With
    RaiseEvent OutputPacketSent(Index, "SID_WRITEUSERDATA")
End Function

Public Function sendSID_LEAVECHAT()
    With PktBuffer
        .Reset
        .Send Winsock, SID_LEAVECHAT, pBNET
    End With
    RaiseEvent OutputPacketSent(Index, "SID_LEAVECHAT")
End Function

Public Function sendSID_CHATCOMMAND(ByVal strText As String)
    With PktBuffer
        .Reset
        .InsertNTString strText
        .Send frmMain.sckBNET(Index), SID_CHATCOMMAND, pBNET
    End With
    RaiseEvent OutputPacketSent(Index, "SID_CHATCOMMAND")
End Function

Private Function UnsignedToLong(Value As Double) As Long
    If Value < 0 Or Value >= 4294967296# Then Error 6 ' Overflow
    If Value <= 2147483647 Then
        UnsignedToLong = Value
    Else
        UnsignedToLong = Value - 4294967296#
    End If
End Function
